/************************************************************************************
   Copyright (C) 2020,2023 MariaDB Corporation AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not see <http://www.gnu.org/licenses>
   or write to the Free Software Foundation, Inc.,
   51 Franklin St., Fifth Floor, Boston, MA 02110, USA
*************************************************************************************/


#ifndef _RESULTS_H_
#define _RESULTS_H_

#include <deque>

#include "Consts.h"
#include "parameters/ParameterHolder.h"
#include "com/CmdInformation.h"
#include "SelectResultSet.h"

namespace sql
{
namespace mariadb
{

class Results  {

  MariaDbStatement*     statement= nullptr;
  ServerPrepareResult*  serverPrepResult= nullptr;
  int32_t     fetchSize=    0;
  bool        batch=        false;
  std::size_t expectedSize= 1;
  Shared::CmdInformation              cmdInformation;
  std::deque<Unique::SelectResultSet> executionResults;
  Unique::SelectResultSet resultSet;
  SelectResultSet* given2appRs= nullptr;
  Shared::SelectResultSet callableResultSet;
  bool    binaryFormat=         false;
  int32_t resultSetScrollType=  ResultSet::TYPE_FORWARD_ONLY;
  int32_t resultSetConcurrency= ResultSet::CONCUR_READ_ONLY;
  int32_t autoGeneratedKeys=    Statement::NO_GENERATED_KEYS;
  int32_t maxFieldSize=   0;
  int32_t autoIncrement=  1;
  bool    rewritten=      false;
  SQLString sql;
  std::vector<Shared::ParameterHolder> parameters;
  bool    haveResultInWire= false;
  bool    cachingLocally=   false;

public:
  Results();
  Results(
    Statement* statement,
    int32_t fetchSize,
    bool batch,
    std::size_t expectedSize,
    bool binaryFormat,
    int32_t resultSetScrollType,
    int32_t resultSetConcurrency,
    int32_t autoGeneratedKeys,
    int32_t autoIncrement,
    const SQLString& sql,
    std::vector<Shared::ParameterHolder>& parameters);
  ~Results();

  void    addStats(int64_t updateCount,int64_t insertId,bool moreResultAvailable);
  void    addStatsError(bool moreResultAvailable);
  int32_t getCurrentStatNumber();
  void    addResultSet(SelectResultSet* resultSet,bool moreResultAvailable);
  Shared::CmdInformation getCmdInformation();

protected:
  void setCmdInformation(CmdInformation* cmdInformation);

public:
  bool commandEnd();
  SelectResultSet* getResultSet();
  ResultSet* releaseResultSet();
  SelectResultSet* getCallableResultSet();
  void loadFully(bool skip, Protocol* protocol);
  void abort();
  bool isFullyLoaded(Protocol* protocol);
  bool getMoreResults(int32_t current, Protocol* protocol);
  int32_t getFetchSize();
  MariaDbStatement* getStatement();
  bool isBatch();
  std::size_t getExpectedSize();
  bool isBinaryFormat();
  void removeFetchSize();
  int32_t getResultSetScrollType();
  const SQLString& getSql();
  std::vector<Shared::ParameterHolder>& getParameters();
  ResultSet* getGeneratedKeys(Protocol* protocol);
  void close();
  int32_t getMaxFieldSize();
  void setAutoIncrement(int32_t autoIncrement);
  int32_t getResultSetConcurrency();
  int32_t getAutoGeneratedKeys();
  bool isRewritten();
  void setRewritten(bool rewritten);
  void checkOut(SelectResultSet* iamleaving);
};

}
}
#endif
