/************************************************************************************
   Copyright (C) 2020 MariaDB Corporation AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not see <http://www.gnu.org/licenses>
   or write to the Free Software Foundation, Inc.,
   51 Franklin St., Fifth Floor, Boston, MA 02110, USA
*************************************************************************************/


#ifndef _BYTEPARAMETER_H_
#define _BYTEPARAMETER_H_

#include "Consts.h"

#include "ParameterHolder.h"

namespace sql
{
namespace mariadb
{

class ByteParameter  : public ParameterHolder {

  static const std::string hexArray ; /*"0123456789ABCDEF".toCharArray()*/
  int8_t value;

public:
  ByteParameter(int8_t value);
  void writeTo(PacketOutputStream& os);
  void writeTo(SQLString& os);
  int64_t getApproximateTextProtocolLength() const;
  void writeBinary(PacketOutputStream& pos);
  uint32_t writeBinary(sql::bytes& buffer);
  const ColumnType& getColumnType() const;
  SQLString toString();
  bool isNullData() const;
  bool isLongData();
  void* getValuePtr() { return static_cast<void*>(&value); }
  unsigned long getValueBinLen() const { return 1; }
  ParameterHolder* clone() { return new ByteParameter(*this); }
  };
}
}
#endif